% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO_Download_Preprocess.R
\name{Preprocess_DNAMethylation}
\alias{Preprocess_DNAMethylation}
\title{The Preprocess_DNAMethylation function}
\usage{
Preprocess_DNAMethylation(
  methylation.data,
  met.platform = "EPIC",
  genome = "hg38",
  sample.info = NULL,
  group.1 = NULL,
  group.2 = NULL,
  sample.map = NULL,
  rm.chr = c("chrX", "chrY"),
  MissingValueThresholdGene = 0.2,
  MissingValueThresholdSample = 0.2,
  doBatchCorrection = FALSE,
  BatchData = NULL,
  batch.correction.method = "Seurat",
  cores = 1
)
}
\arguments{
\item{methylation.data}{matrix of DNA methylation data with CpG in rows and sample names in columns.}

\item{met.platform}{character string indicating the type of the Illumina Infinium BeadChip for collecting the methylation data. Should be either 'HM450' or 'EPIC'. Default: 'EPIC'}

\item{genome}{character string indicating the genome build version for retrieving the probe annotation. Should be either 'hg19' or 'hg38'. Default: 'hg38'.}

\item{sample.info}{dataframe that maps each sample to a study group. Should contain two columns: the first column (named: 'primary') indicating the sample names, and the second column (named: 'sample.type') indicating which study group each sample belongs to (e.g., “Experiment” vs. “Control”,  “Cancer” vs. “Normal”). Sample names in the 'primary' column must coincide with the column names of the methylation.data. Please see details for more information. Default: NULL.}

\item{group.1}{character vector indicating the name(s) for the experiment group. The values must coincide with the values in the 'sample.type' of the sample.info dataframe.Please see details for more information. Default: NULL.}

\item{group.2}{character vector indicating the names(s) for the control group. The values must coincide with the values in the 'sample.type' of the sample.info dataframe. Please see details for more information. Default: NULL.}

\item{sample.map}{dataframe for mapping the GEO accession ID (column names) to the actual sample names. Can be the output from the GEO_getSampleMap function. Default: NULL.}

\item{rm.chr}{character vector indicating the probes on which chromosomes to be removed. Default: 'chrX', 'chrY'.}

\item{MissingValueThresholdGene}{threshold for missing values per gene. Genes with a percentage of NAs greater than this threshold are removed. Default: 0.3.}

\item{MissingValueThresholdSample}{threshold for missing values per sample. Samples with a percentage of NAs greater than this threshold are removed. Default: 0.1.}

\item{doBatchCorrection}{logical indicating whether to perform batch correction. If TRUE, the batch data need to be provided.}

\item{BatchData}{dataframe with batch information. Should contain two columns: the first column indicating the actual sample names, the second column indicating the batch. Users are expected to retrieve the batch information from the GEO on their own, but this can also be done using the GEO_getSampleInfo function with the 'group.column' as the column indicating the batch for each sample. Defualt': NULL.}

\item{batch.correction.method}{character string indicating the method that will be used for batch correction. Should be either 'Seurat' or 'Combat'. Default: 'Seurat'.}

\item{cores}{number of CPU cores to be used for batch effect correction. Defaut: 1.}
}
\value{
DNA methylation data matrix with probes in rows and samples in columns.
}
\description{
Preprocess DNA methylation data from the GEO database.
}
\details{
The data preprocessing pipeline includes:
(1) eliminating samples and genes with too many NAs, imputing NAs.
(2) (optional) mapping the column names of the DNA methylation data to the actual sample names based on the information from 'sample.map'.
(3) (optional) removing CpG probes on the sex chromosomes or the user-defined chromosomes.
(4) (optional) doing Batch correction.
If both sample.info and group.1 and group.2 information are provided, the function will perform missing value estimation and batch correction on group.1 and group.2 separately. This will ensure that the true difference between group.1 and group.2 will not be obscured by missing value estimation and batch correction.
}
\examples{
{
data(MET.data)
data(LUAD.sample.annotation)

Preprocessed_Data <- Preprocess_DNAMethylation(MET.data,
                                                   met.platform = 'HM450',
                                                   sample.info = LUAD.sample.annotation,
                                                   group.1 = 'Cancer',
                                                   group.2 = 'Normal')

}
}
\keyword{preprocess}
