% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hg19_blacklist}
\alias{hg19_blacklist}
\title{Human genome hg19 blacklisted regions}
\format{
An object of class \code{GRanges} of length 411.
}
\source{
The code to prepare the .Rda file is:

\code{# blacklisted regions were directly downloaded} \cr
\code{# from https://www.encodeproject.org/files/ENCFF001TDO/} \cr
\code{hg19_blacklist <- 
ChIPseeker::readPeakFile(file.path(path), as = "GRanges")} \cr
\code{usethis::use_data(hg19_blacklist, overwrite = TRUE)} \cr
}
\usage{
data("hg19_blacklist")
}
\description{
Obtained from \url{https://www.encodeproject.org/files/ENCFF001TDO/}.
The ENCODE blacklist includes regions of the hg19 genome that have anomalous
and/or unstructured signals independent of the cell-line or experiment.
Removal of ENCODE blacklist is recommended for quality measure.
}
\keyword{datasets}
