% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bpparam.R
\name{get_bpparam}
\alias{get_bpparam}
\title{Get \link[BiocParallel]{BiocParallel} parameters}
\usage{
get_bpparam(
  workers,
  progressbar = workers > 1,
  use_snowparam = TRUE,
  register_now = FALSE
)
}
\arguments{
\item{workers}{Number of threads to parallelize across.}

\item{progressbar}{
    \code{logical(1)} Enable progress bar (based on plyr:::progress_text).
  }

\item{use_snowparam}{Whether to use
\link[BiocParallel]{SnowParam} (default: \code{TRUE}) or
\link[BiocParallel]{MulticoreParam} (\code{FALSE})
 when parallelising across multiple \code{workers}.}

\item{register_now}{Register the cores now with
\link[BiocParallel]{register} (\code{TRUE}),
 or simply return the \code{BPPARAM object} (default: \code{FALSE}).}
}
\value{
BPPARAM
}
\description{
Get (and optionally register) \link[BiocParallel]{BiocParallel} parameter 
(\code{BPPARAM}). \link[BiocParallel]{SnowParam} is the default function
as it tends to be more robust. However, because it doesn't work on Windows, 
this function automatically detected the Operating System and switches 
to  \link[BiocParallel]{SerialParam} as needed.
}
\keyword{internal}
