% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichDO_visualization.R
\name{drawHeatmap}
\alias{drawHeatmap}
\title{drawHeatmap}
\usage{
drawHeatmap(
  interestGenes,
  EnrichResult = NULL,
  DOID_n = 10,
  gene_n = 50,
  fontsize_row = 10,
  ...
)
}
\arguments{
\item{interestGenes}{A collection of interest genes in vector form}

\item{EnrichResult}{the EnrichResult object}

\item{DOID_n}{There are DOID_n nodes with the highest significance in the enrichment results.}

\item{gene_n}{Among the selected DOID_n nodes, the top gene_n genes with the highest weight sum are selected to show.}

\item{fontsize_row}{Set the font size of the gene tag.}

\item{...}{Other parameters in the pheatmap function also apply.}
}
\value{
heat map
}
\description{
The top DOID_n nodes in the enrichment results showed the top gene_n genes with the highest weight sum.
}
\examples{
demo.data <- c(1636,351,102,2932,3077,348,4137,54209)
sample6 <- doEnrich(interestGenes=demo.data,maxGsize = 100, minGsize=10)
drawHeatmap(interestGenes=demo.data, EnrichResult = sample6, gene_n = 10)
}
\author{
Haixiu Yang
}
