% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricMCB.R
\name{metricMCB}
\alias{metricMCB}
\title{Calculation of the metric matrix for Methylation Correlation Block}
\usage{
metricMCB(MCBset,training_set,Surv,testing_set,
Surv.new,Method,predict_time,ci,silent,alpha,n_mstop,n_nu,theta)
}
\arguments{
\item{MCBset}{Methylation Correlation Block information returned by the IndentifyMCB function.}

\item{training_set}{methylation matrix used for training the model in the analysis.}

\item{Surv}{Survival function contain the survival information for training.}

\item{testing_set}{methylation matrix used in the analysis. This can be missing then training set itself will be used as testing set.}

\item{Surv.new}{Survival function contain the survival information for testing.}

\item{Method}{model used to calculate the compound values for multiple Methylation correlation blocks. \cr
Options include "svm" "cox" "mboost" and "enet". The default option is SVM method.}

\item{predict_time}{time point of the ROC curve used in the AUC calculations, default is 5 years.}

\item{ci}{if True, the confidence intervals for AUC under area under the receiver operating characteristic curve will be calculated. This will be time consuming. default is False.}

\item{silent}{True indicates that processing information and progress bar will be shown.}

\item{alpha}{The elasticnet mixing parameter, with 0 <= alpha <= 1. alpha=1 is the lasso penalty, and alpha=0 the ridge penalty. \cr
It works only when "enet" Method is selected.}

\item{n_mstop}{an integer giving the number of initial boosting iterations. If mstop = 0, the offset model is returned. \cr
It works only when "mboost" Method is selected.}

\item{n_nu}{a double (between 0 and 1) defining the step size or shrinkage parameter in mboost model. \cr
It works only when "mboost" Method is selected.}

\item{theta}{penalty used in the penalized coxph model, which is theta/2 time sum of squared coefficients. default is 1. \cr
It works only when "cox" Method is selected.}
}
\value{
Object of class \code{list} with elements (XXX will be replaced with the model name you choose):
 \tabular{ll}{
   \code{MCB_XXX_matrix_training} \tab Prediction results of model for training set. \cr
   \code{MCB_XXX_matrix_test_set} \tab Prediction results of model for test set. \cr
   \code{XXX_auc_results} \tab AUC results for each model. \cr
   \code{best_XXX_model} \tab Model object for the model with best AUC. \cr
   \code{maximum_auc} \tab Maximum AUC for the whole generated models. \cr
 }
}
\description{
To enable quantitative analysis of the methylation patterns \cr
within individual Methylation Correlation Blocks across many samples, a single metric to \cr
define the methylated pattern of multiple CpG sites within each block.\cr
Compound scores which calculated all CpGs within individual Methylation Correlation Blocks by linear, SVM or elastic-net model\cr
Predict values were used as the compound methylation values of Methylation Correlation Blocks.
}
\examples{
#import datasets
data(demo_survival_data)
datamatrix<-create_demo()
data(demo_MCBinformation)
#select MCB with at least 3 CpGs.
demo_MCBinformation<-demo_MCBinformation[demo_MCBinformation[,"CpGs_num"]>2,]

trainingset<-colnames(datamatrix) \%in\% sample(colnames(datamatrix),0.6*length(colnames(datamatrix)))
testingset<-!trainingset
#create the results using Cox regression. 
mcb_cox_res<-metricMCB(MCBset = demo_MCBinformation,
               training_set = datamatrix[,trainingset],
               Surv = demo_survival_data[trainingset],
               testing_set = datamatrix[,testingset],
               Surv.new = demo_survival_data[testingset],
               Method = "cox"
               )

}
\references{
Xin Yu et al. 2019 Predicting disease progression in lung adenocarcinoma patients based on methylation correlated blocks using ensemble machine learning classifiers (under review)
}
\author{
Xin Yu
}
\keyword{Correlation}
\keyword{Methylation}
