% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_roc_calculation.R
\name{fast_roc_calculation}
\alias{fast_roc_calculation}
\title{Fast calculation of AUC for ROC using parallel strategy}
\usage{
fast_roc_calculation(test_matrix, y_surv, predict_time = 5, roc_method = "NNE")
}
\arguments{
\item{test_matrix}{Test matrix used in the analysis. Colmuns are samples, rows are markers.}

\item{y_surv}{Survival information created by Surv function in survival package.}

\item{predict_time}{Time point of the ROC curve, default is 5 year.}

\item{roc_method}{Method for fitting joint distribution of (marker,t), either of KM or NNE, the default method is NNE.}
}
\value{
This will retrun a numeric vector contains AUC results for each row in test_matrix.
}
\description{
This function is used to create time-dependent ROC curve from censored survival data using the Kaplan-Meier (KM) or Nearest Neighbor Estimation (NNE) method of Heagerty, Lumley and Pepe, 2000
}
\examples{
data(demo_survival_data)
data('demo_data',package = "EnMCB")
demo_set<-demo_data$realdata
res<-fast_roc_calculation(demo_set[1:2,],demo_survival_data)

}
\author{
Xin Yu
}
