% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dotplot.R
\name{ggplot2_dotplot}
\alias{ggplot2_dotplot}
\title{Plot number of DE genes}
\usage{
ggplot2_dotplot(deg = NULL, path = ".", save_plot = TRUE)
}
\arguments{
\item{deg}{The list of DE genes generated by one of ERSSA::DE_*.R scripts.}

\item{path}{Path to which the plot will be saved. Default to current working
directory.}

\item{save_plot}{Boolean. Whether to save plot to drive. Default to TRUE.}
}
\value{
A list is returned containing:
 \itemize{
  \item{gg_object} {the ggplot2 object, which can then be further
  customized.}
  \item{deg_dataframe} {the tidy table version of DEG numbers for plotting.}
  \item{full_num_DEG} {The number of DE genes with all samples included.}
}
}
\description{
\code{ggplot2_dotplot} function plots the number of differentially expressed
(DE) genes in each test.
}
\details{
The number of DE genes are plotted as dots grouped by the associated
replicate level. At each replicate level, a boxplot is drawn to mainly show
the first and third quartiles as well as the median. Additionally,
A red line is drawn representing the mean at each replicate level. A
horizontal dashed blue line represents the number of DE genes found with
all samples.
}
\examples{
# load edgeR deg object generated by erssa_edger using example dataset
# example dataset containing 1000 genes, 4 replicates and 5 comb. per rep.
# level
data(deg.partial, package = "ERSSA")

gg_dot = ggplot2_dotplot(deg.partial)

}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York, 2009.
}
\author{
Zixuan Shao, \email{Zixuanshao.zach@gmail.com}
}
