% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_emdperms}
\alias{plot_emdperms}
\title{Plot histogram of EMD scores calculated via random permutation.}
\usage{
plot_emdperms(emdobj)
}
\arguments{
\item{emdobj}{An \code{\link{EMDomics}} object, typically returned via a call
to \code{\link{calculate_emd}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object is returned. If the value is
not assigned, a plot will be drawn.
}
\description{
The permuted EMD scores stored in \code{emdobj$emd.perm} are
plotted as a histogram.
}
\examples{
# 100 genes, 100 samples
dat <- matrix(rnorm(10000), nrow=100, ncol=100)
rownames(dat) <- paste("gene", 1:100, sep="")
colnames(dat) <- paste("sample", 1:100, sep="")

# "A": first 50 samples; "B": next 30 samples; "C": final 20 samples
outcomes <- c(rep("A",50), rep("B",30), rep("C",20))
names(outcomes) <- colnames(dat)

results <- calculate_emd(dat, outcomes, nperm=10, parallel=FALSE)
plot_emdperms(results)
}
\seealso{
\code{\link{calculate_emd}} \code{\link[ggplot2]{ggplot}}
}

