% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/KS.R
\name{calculate_ks_gene}
\alias{calculate_ks_gene}
\title{Calculate KS score for a single gene}
\usage{
calculate_ks_gene(vec, outcomes, sample_names)
}
\arguments{
\item{vec}{A named vector containing data (e.g. expression data) for a single
gene.}

\item{outcomes}{A vector of group labels for the samples. The names must correspond
to the names of \code{vec}.}

\item{sample_names}{A character vector with the names of the samples in \code{vec}.}
}
\value{
The KS score is returned.
}
\description{
Calculate KS score for a single gene
}
\details{
All possible combinations of the classes are used as pairwise comparisons.
The data in \code{vec} is divided based on class labels based on the \code{outcomes}
identifiers given. For each pairwise computation, \code{\link{ks.test}} is used to compute
the pairwise KS scores. The
total KS score for the given data is the average of the pairwise KS scores.
}
\examples{
# 100 genes, 100 samples
dat <- matrix(rnorm(100000), nrow=100, ncol=1000)
rownames(dat) <- paste("gene", 1:100, sep="")
colnames(dat) <- paste("sample", 1:1000, sep="")

# assign outcomes
outcomes <- c(rep(1,500), rep(2,300), rep(3,200))
names(outcomes) <- colnames(dat)

calculate_ks_gene(dat[1,], outcomes, colnames(dat))
}
\seealso{
\code{\link{ks.test}}
}

