% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EMD.R
\name{EMDomics}
\alias{EMDomics}
\title{Create an EMDomics object}
\usage{
EMDomics(data, outcomes, emd, emd.perm, pairwise.emd.table, pairwise.q.table)
}
\arguments{
\item{data}{A matrix containing genomics data (e.g. gene expression levels).
The rownames should contain gene identifiers, while the column names should
contain sample identifiers.}

\item{outcomes}{A vector of group labels for each of the sample identifiers. The
names of this vector must correspond to the column names of \code{data}.}

\item{emd}{A matrix containing a row for each gene in \code{data}, and with
the following columns:
\itemize{
\item \code{emd} The calculated emd score.
\item \code{q-value} The calculated q-value.
}
The row names should specify the gene identifiers for each row.}

\item{emd.perm}{A matrix containing a row for each gene in \code{data}, and
with a column containing emd scores for each random permutation calculated
via \code{\link{calculate_emd}}.}

\item{pairwise.emd.table}{A table containing the EMD scores for each pairwise
comparison for each gene. For a two-class problem, there should be only one column
comparing class 1 and class 2. The row names should be gene identifiers. The column
names should be in the format "<class 1> vs <class 2>" (e.g. "1 vs 2" or "A vs B").}

\item{pairwise.q.table}{A table containing the permutation-based q-values for each
pairwise comparison for each gene. May be \code{NULL} if \code{pairwise.p=F}.}
}
\value{
The function combines its arguments in a list, which is assigned class
'EMDomics'. The resulting object is returned.
}
\description{
This is the constructor for objects of class 'EMDomics'. It
is used in \code{\link{calculate_emd}} to construct the return value.
}
\seealso{
\code{\link{calculate_emd}}
}

