% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif.TF.Plots.R
\name{TF.rank.plot}
\alias{TF.rank.plot}
\title{TF.rank.plot to plot the scores (-log10(P value)) which assess the correlation between 
TF expression and average DNA methylation at motif sites.}
\usage{
TF.rank.plot(
  motif.pvalue,
  motif,
  title = NULL,
  TF.label = NULL,
  dir.out = "./",
  save = TRUE,
  cores = 1
)
}
\arguments{
\item{motif.pvalue}{A matrix or a path specifying location of  "XXX.with.motif.pvalue.rda"
which is output of getTF.}

\item{motif}{A vector of characters specify the motif to plot}

\item{title}{Tite title (the motif will still be added to the title)}

\item{TF.label}{A list shows the label for each motif. If TF.label is not specified, 
the motif relevant TF and top3 TF will be labeled.}

\item{dir.out}{A path specify the directory to which the figures will be saved. 
Current directory is default.}

\item{save}{A logic. If true (default), figure will be saved to dir.out}

\item{cores}{A interger which defines the number of cores to be used in parallel process. 
Default is 1: no parallel process.}
}
\value{
A plot shows the score (-log(P value)) of association between TF
expression and DNA methylation at sites of a certain motif.
}
\description{
TF.rank.plot is a function to plot the scores (-log10(P value)) which assess the
correlation between TF expression and average DNA methylation at motif sites. The the motif 
relevant TF and top3 TFs will be labeled in a different color.
}
\examples{
library(ELMER)
data <- tryCatch(ELMER:::getdata("elmer.data.example"), error = function(e) {
  message(e)
  data(elmer.data.example, envir = environment())
})
enriched.motif <- list("P53_HUMAN.H11MO.0.A"= c("cg00329272", "cg10097755", "cg08928189",
                                 "cg17153775", "cg21156590", "cg19749688", "cg12590404",
                                 "cg24517858", "cg00329272", "cg09010107", "cg15386853",
                                 "cg10097755", "cg09247779", "cg09181054"))
TF <- get.TFs(data, 
              enriched.motif, 
              group.col = "definition",
              group1 = "Primary solid Tumor", 
              group2 = "Solid Tissue Normal",
              TFs = data.frame(
                     external_gene_name=c("TP53","TP63","TP73"),
                     ensembl_gene_id= c("ENSG00000141510",
                                        "ENSG00000073282",
                                        "ENSG00000078900"),
                     stringsAsFactors = FALSE),
             label="hypo")
TF.meth.cor <- get(load("getTF.hypo.TFs.with.motif.pvalue.rda"))            
TF.rank.plot(motif.pvalue=TF.meth.cor,  
            motif="P53_HUMAN.H11MO.0.A", 
            TF.label=createMotifRelevantTfs("subfamily")["P53_HUMAN.H11MO.0.A"],
            save=TRUE)
TF.rank.plot(motif.pvalue=TF.meth.cor,  
            motif="P53_HUMAN.H11MO.0.A", 
            save=TRUE)
# Same as above
TF.rank.plot(motif.pvalue=TF.meth.cor,  
            motif="P53_HUMAN.H11MO.0.A", 
            dir.out = "TFplots",
            TF.label=createMotifRelevantTfs("family")["P53_HUMAN.H11MO.0.A"],
            save=TRUE)
}
\author{
Lijing Yao (maintainer: lijingya@usc.edu)
}
