% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_network_cols.R
\name{filter_network_cols}
\alias{filter_network_cols}
\title{Filter on columns}
\usage{
filter_network_cols(network, min = 0, max = 1, ids = NA)
}
\arguments{
\item{network}{numeric matrix}

\item{min}{numeric value}

\item{max}{numeric value}

\item{ids}{array}
}
\value{
network numeric matrix
}
\description{
The function filters out the columns of a matrix such that the size of the group
is exclusively between given min and max values
}
\examples{
genes.labels <- matrix( sample( c(0,1), 10000, replace=TRUE), nrow=100)
rownames(genes.labels) = paste('gene', 1:100, sep='')
colnames(genes.labels) = paste('function', 1:100, sep='')
genes.labels <- filter_network_cols(genes.labels,50,200)

genes.labels <- matrix( sample( c(0,1), 10000, replace=TRUE), nrow=100)
rownames(genes.labels) = paste('gene', 1:100, sep='')
colnames(genes.labels) = paste('function', 1:100, sep='')
genes.labels <- filter_network_cols(genes.labels,ids = paste('function', 1:20, sep=''))


}
\keyword{filter}
\keyword{network}
\keyword{rows}
