% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDIRquery.R
\name{gene_lookup}
\alias{gene_lookup}
\title{Look Up a Gene in EDIR Dataset}
\usage{
gene_lookup(
  gene,
  length = NA,
  mindist = 0,
  maxdist = 1000,
  format = "data.frame",
  summary = FALSE,
  mismatch = TRUE,
  path = NA
)
}
\arguments{
\item{gene}{The gene name (ENSEMBL ID or HGNC symbol)}

\item{length}{Repeat sequence length, must be between 7 and 20. Defaults to
NA. If NA, results will include all available lengths in dataset for queried
gene.}

\item{mindist}{Minimum spacer distance between repeats. Defaults to 0.}

\item{maxdist}{Maximum spacer distance between repeats. Defaults to 1000.}

\item{format}{Output table format. One of 'data.frame', 'GInteractions'.
Defaults to 'data.frame'.}

\item{summary}{Logical value indicating whether to store summary. Defaults
to FALSE.}

\item{mismatch}{Logical value indicating whether to allow 1 mismatch in
sequences. Defaults to TRUE.}

\item{path}{String containing path to directory holding downloaded dataset
files. Defaults to NA. If not provided (\code{path} = NA),
\code{gene_lookup()} will use subset of data provided as example.}
}
\value{
A data.frame of the results from the EDIR database. If
\code{summary = TRUE}, returns a tibble containing the summary
(\verb{$summary}), and query results (\verb{$results}).
}
\description{
This function searches for a specified gene in the EDIR dataset. A gene name
is a required parameter.
}
\details{
Summary of results printed to console includes gene name, gene length (bp),
Ensembl transcript ID, queried distance between repeats (default: 0-1000 bp),
and an overview of total results for the given repeat length. Console outputs
include runtime.
}
\examples{
## With given repeat length,
gene_lookup("GAA", length = 7, mindist = 10, maxdist = 1000,
            mismatch = TRUE)

## Without specified repeat length
gene_lookup("GAA", mindist = 0, maxdist = 1000, mismatch = TRUE)

## To access query results, store in variable
output <- gene_lookup("GAA", length = 7, mindist = 10, maxdist = 1000,
                        mismatch = FALSE)
head(output)

## With summary = TRUE
output <- gene_lookup("GAA", length = 10, mindist = 10, maxdist = 1000,
                        summary = TRUE,
                        mismatch = TRUE)
output$summary
head(output$results)
}
