% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_general.R
\name{makeGiFromDf}
\alias{makeGiFromDf}
\title{Convert Dataframe to GInteractions}
\usage{
makeGiFromDf(df)
}
\arguments{
\item{df}{dataframe-like object. Should be convertable to tibble::tibble()}
}
\value{
GInteractions(mode='strict')
}
\description{
Converts dataframe-like object to the \code{GInteractions}.
}
\details{
arms will be consistent between different objects of same reference
Following columns are looked up in input dataframe  to parse region coordinates:
c("chromA','startA','endA','strandA',"chromB",'startB','endB','strandB')
\code{GInteractions(mode='strict')} is enforced, to ensure that the order of the regions
Extra columns are stored as metadata fields
}
\examples{
# load example GInteractions
data(RNADuplexesSmallGI)

converted_to_df <- makeDfFromGi(SampleSmallGI)
converted_to_gi <- makeGiFromDf(converted_to_df)
}
\seealso{
\code{\link[=makeDfFromGi]{makeDfFromGi()}}
}
