% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplexDiscovererResults.R
\docType{methods}
\name{dd_get_reads_classes}
\alias{dd_get_reads_classes}
\alias{dd_get_reads_classes,DuplexDiscovererResults-method}
\title{Accessor for \code{reads_classes} Slot}
\usage{
dd_get_reads_classes(object)

\S4method{dd_get_reads_classes}{DuplexDiscovererResults}(object)
}
\arguments{
\item{object}{A \code{DuplexDiscovererResults} object.}
}
\value{
\code{tibble} from the \code{reads_classes} slot.
}
\description{
Retrieves the value of the \code{reads_classes} slot in a \code{DuplexDiscovererResults} object.
}
\examples{

# load example input
data("RNADuplexesSmallGI")
data("RNADuplexesSampleData")
# run whole pipeline
result <- runDuplexDiscoverer(
    data = SampleSmallGI,
    junctions_gr = SampleSpliceJncGR,
    anno_gr = SampleGeneAnnoGR,
    sample_name = "run_example",
    lib_type = "SE",
    table_type = "STAR"
)
# access results
show(result)
gi_clusters <- dd_get_duplex_groups(result)
gi_reads <- dd_get_chimeric_reads(result)
df_reads <- dd_get_reads_classes(result)
dd_get_reads_classes(result)
dd_get_run_stats(result)
}
