% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{functionTracking}
\alias{functionTracking}
\title{Track the evolution of a function along merging}
\usage{
functionTracking(merger, f, p = 1, n_steps = NULL, ...)
}
\arguments{
\item{merger}{the result from having run \code{\link{Dune}}
on the dataset}

\item{f}{the function used. It must takes as input a clustering matrix and
return a value}

\item{p}{A value between 0 and 1. We stop when the metric used for merging has
improved by p of the final total improvement. Default to 1 (i.e running the full merging).}

\item{n_steps}{Alternatively, you can specifiy the number of merging steps to
do before stopping.}

\item{...}{additional arguments passed to f}
}
\value{
a vector of length the number of merges
}
\description{
For a given ARI merging, compute the evolution on the function f
}
\examples{
# Return the number of clusters for the fourth cluster label
data("clusMat", package = "Dune")
merger <- Dune(clusMat = clusMat)
f <- function(clusMat, i) dplyr::n_distinct(clusMat[, i])
functionTracking(merger, f, i = 4)
}
