% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ConfusionEvolution}
\alias{ConfusionEvolution}
\title{Plot the evolution of the ConfusionPlot as merging
happens}
\usage{
ConfusionEvolution(merger, unclustered = NULL, x, y, state_length = 1)
}
\arguments{
\item{merger}{the result from having run \code{\link{Dune}}
on the dataset}

\item{unclustered}{The value assigned to unclustered cells. Default to \code{NULL}}

\item{x}{The name of the first cluster label to plot}

\item{y}{The name of the second cluster label to plot}

\item{state_length}{Time between steps. Default to 1. See \code{\link{transition_states}}
for details.}
}
\value{
a \code{gganim} object
}
\description{
Animated version of \code{\link{ConfusionPlot}}
}
\details{
See \code{\link{ConfusionPlot}} and \code{\link{animate}}.
}
\examples{
\dontrun{
  data("clusMat", package = "Dune")
  merger <- Dune(clusMat = clusMat)
  ConfusionEvolution(merger, x = "A", y = "B")}
}
