% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dino.R
\name{Dino_SCE}
\alias{Dino_SCE}
\title{Run Dino normalization on a SingleCellExperiment dataset}
\usage{
Dino_SCE(SCE, ...)
}
\arguments{
\item{SCE}{A \emph{SingleCellExperiment} object with unnormalized count data
(eg. raw  UMIs) in the \emph{assays} slot under the name \emph{counts}.}

\item{...}{Further arguments to pass to \emph{Dino}}
}
\value{
\code{Dino_SCE} returns a \emph{SingleCellExperiment} object using
    Dino normalized expression in the \emph{assays} slot under the
    \emph{normcounts} name for downstream analysis.

    If \emph{returnMeta = T} is passed to \emph{Dino}, then \emph{depth} and
    \emph{slope} results are stored in the \emph{metadata} slot under the
    names \emph{depth} and \emph{slope} respectively.
}
\description{
\code{Dino_SCE} is a wrapper simplifying the application of the
    \emph{Dino} method to data formatted as a \emph{SingleCellExperiment}
}
\examples{
# raw data
data("pbmcSmall")
str(pbmcSmall)

# format as SingleCellExperiment
library(SingleCellExperiment)
pbmc_SCE <- SingleCellExperiment(assays = list("counts" = pbmcSmall))

# Run Dino
pbmc_SCE <- Dino_SCE(pbmc_SCE)
str(pbmc_SCE)
str(normcounts(pbmc_SCE))

}
\references{
Brown, J., Ni, Z., Mohanty, C., Bacher, R. and Kendziorski, C.
    (2020). "Normalization by distributional resampling of high throughput
    single-cell RNA-sequencing data." bioRxiv.
    \href{https://doi.org/10.1101/2020.10.28.359901}{https://doi.org/10.1101/2020.10.28.359901}

    Amezquita, R.A., Lun, A.T.L., Becht, E., Carey, V.J., Carpp, L.N.,
    Geistlinger, L., Marini, F., Rue-Albrecht, K., Risso, D., Soneson, C.,
    et al. (2020). "Orchestrating single-cell analysis with Bioconductor."
    Nat. Methods, 17, 137–145.
    \href{https://doi.org/10.1038/s41592-019-0654-x}{https://doi.org/10.1038/s41592-019-0654-x}
}
\author{
Jared Brown
}
