% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_bulk_US.R
\name{load_bulk_US}
\alias{load_bulk_US}
\title{Creates a SummarizedExperiment containing the estimated US counts for the bulk RNA-seq data}
\usage{
load_bulk_US(path_to_quant_files, sample_ids)
}
\arguments{
\item{path_to_quant_files}{a vector of length equals to the number of samples: 
each element indicates the path to the US estimated count matrix of the respective sample (i.e., quant.sf file).}

\item{sample_ids}{a vector of length equals to the number of samples,
indicating the names of the respective samples in `path_to_quant_files`.}
}
\value{
A \code{SummarizedExperiment} object.
}
\description{
\code{load_bulk_US} imports the bulk estimated US (Unspliced, and Spliced) 
counts (computed by salmon), and stores them into a \code{SummarizedExperiment} object.
}
\examples{
# load internal data to the package:
data_dir = system.file("extdata", package = "DifferentialRegulation")

# specify samples ids:
sample_ids = paste0("sample", seq_len(6))

# US estimates:
quant_files = file.path(data_dir, "salmon", sample_ids, "quant.sf")
file.exists(quant_files)

# load US estimated counts:
SE = load_bulk_US(quant_files,
                  sample_ids)

}
\seealso{
\code{\link{load_bulk_EC}}, \code{\link{DifferentialRegulation_bulk}}
}
\author{
Simone Tiberi \email{simone.tiberi@unibo.it}
}
