% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffSeqLogoSupport.R
\name{diffLogoTableConfiguration}
\alias{diffLogoTableConfiguration}
\title{Configuration object for diffLogoTable}
\usage{
diffLogoTableConfiguration(alphabet, stackHeight = shannonDivergence,
  baseDistribution = normalizedDifferenceOfProbabilities,
  uniformYaxis = TRUE, sparse = TRUE, showSequenceLogosTop = TRUE,
  enableClustering = TRUE, treeHeight = 0.5, margin = 0.02,
  ratio = 1, align_pwms = FALSE, multiple_align_pwms = TRUE,
  unaligned_penalty = divergencePenaltyForUnaligned,
  try_reverse_complement = TRUE, length_normalization = FALSE,
  numberOfPermutations = 100)
}
\arguments{
\item{alphabet}{used alphabet of type Alphabet}

\item{stackHeight}{function for the height of a stack at position i}

\item{baseDistribution}{function for the heights of the individual bases}

\item{uniformYaxis}{if TRUE each DiffLogo is plotted with the same scaling of the y-axis}

\item{sparse}{if TRUE margins are reduced and tickmarks are removed from the logo}

\item{showSequenceLogosTop}{if TRUE the classical sequence logos are drawn above each column of the table}

\item{enableClustering}{if TRUE the motifs are reordered, so that similar motifs have a small vertical and horizontal distance in the table}

\item{treeHeight}{the height of the plotted cluster tree above the columns of the table; set equal to zero to omit the cluster tree}

\item{margin}{the space reseverved for labels}

\item{ratio}{the ratio of the plot; this is needed to determine the margin sizes correctly}

\item{align_pwms}{if True, will align and extend pwms in each cell of diffLogoTable independently.}

\item{multiple_align_pwms}{if True, will align and extend pwms in the diffLogoTable jointly.}

\item{unaligned_penalty}{is a function for localPwmAlignment.}

\item{try_reverse_complement}{if True, alignment will try reverse complement pwms}

\item{length_normalization}{if True, divergence between pwms is divided by length of pwms.}

\item{numberOfPermutations}{number of permutations for the permutation test for the calculation of p-values}
}
\value{
list of parameters
}
\description{
Default configuration list for diffLogoTable
}
\examples{
diffLogoTableConfiguration(DNA)
}
\author{
Lando Andrey
}
