% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomWeibullArray-class.R
\docType{class}
\name{RandomWeibullArray-class}
\alias{RandomWeibullArray-class}
\alias{RandomWeibullArraySeed-class}
\alias{RandomWeibullMatrix-class}
\alias{sampleDistrParam,RandomWeibullArraySeed-method}
\alias{sampleDistrFun,RandomWeibullArraySeed-method}
\alias{matrixClass,RandomWeibullArray-method}
\alias{RandomWeibullArraySeed}
\alias{DelayedArray,RandomWeibullArraySeed-method}
\alias{RandomWeibullArray}
\title{DelayedArray of random Weibull-distributed values}
\usage{
RandomWeibullArraySeed(dim, shape, scale = 1, chunkdim = NULL)

\S4method{DelayedArray}{RandomWeibullArraySeed}(seed)

RandomWeibullArray(dim, shape, scale = 1, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{shape, scale}{Numeric vector used as the argument of the same name in \code{\link{qweibull}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomWeibullArraySeed object.}
}
\value{
All constructors return an instance of a RandomWeibullArray object,
containing random draws from a Weibull distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of Weibull-distributed values.
}
\examples{
X <- RandomWeibullArraySeed(c(1e5, 1e5), shape=10)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomWeibullArraySeed(c(1e5, 1e5), shape=round(runif(1e5, 10, 20)))
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
shape <- round(RandomUnifArray(c(1e5, 1e5), 10, 20))
X3 <- RandomWeibullArraySeed(c(1e5, 1e5), shape=shape)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
