% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCrePlotFuns.R
\name{plotDegCreAssocProbVsDist}
\alias{plotDegCreAssocProbVsDist}
\title{Plot DegCre Association Probability vs. Binned Genomic Distance}
\usage{
plotDegCreAssocProbVsDist(
  degCreResList,
  assocProbFDRThresh = 0.05,
  plotQRange = c(0.25, 0.75),
  hiYLim = NULL,
  loYLim = NULL,
  qRangeFillColor = "#88CCEE",
  nullLineColor = "#CC6677"
)
}
\arguments{
\item{degCreResList}{A list of DegCre results.}

\item{assocProbFDRThresh}{Numeric value from 0 to 1 specifying the FDR
threshold for association probability. (Default: \code{0.05})}

\item{plotQRange}{Numeric vector of quantile range for plotting
(e.g., \code{c(0.25, 0.75)} for interquartile range).
(Default: \code{c(0.25, 0.75)})}

\item{hiYLim}{Numeric value specifying the upper limit of the y-axis.
(Default: \code{NULL})}

\item{loYLim}{Numeric value specifying the lower limit of the y-axis.
(Default: \code{NULL})}

\item{qRangeFillColor}{Color for filling the quantile range polygon.
(Default: \code{#88CCEE})}

\item{nullLineColor}{Color for the null association probability line.
(Default: \code{#CC6677})}
}
\value{
Invisibly, a matrix with these columns:
\describe{
  \item{binMidDist}{Numeric value of the midpoint distance of the bin
  (TSS to CRE) in kb.}
  \item{q_<\code{plotQRange[1] x 100}>}{Numeric value of lower bound of the
  highlight region.}
  \item{q_50}{Numeric value of plotted line.}
  \item{q_<\code{plotQRange[2] x 100}>}{Numeric value of upper bound of the
  highlight region.}
  \item{nullAssocProb}{Numeric of null association probability of the bin.}
}
}
\description{
Plots the DegCre association probability against binned genomic distance and
highlights the quantile range.
}
\details{
This function takes the results of the DegCre analysis, including genomic
distances and association probabilities, and creates a plot of association
probabilities against binned genomic distances. It highlights the quantile
range (e.g., interquartile range) and includes a line for null association
probabilities.
The top panel shows the number of associations passing
\code{assocProbFDRThresh}. The bottom panel shows the median FDR-passing
association probability as a black line, with the specified quantile range
(defaults to interquartile) plotted as \code{qRangeFillColor} region.
The \code{nullLineColor} colored line is the null association probability,
that is the association probability for a bin with uniform CRE p-values.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load example data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

#Plot association probability versus binned genomic distance.

outProbVsDistMat <-
 plotDegCreAssocProbVsDist(degCreResList=degCreResListDexNR3C1)

}
\author{
Brian S. Roberts
}
