% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreCore.R
\name{getAssocDistHits}
\alias{getAssocDistHits}
\title{Get Associations and Distances Between Genomic Regions}
\usage{
getAssocDistHits(DegGR, CreGR, maxDist = 1e+06)
}
\arguments{
\item{DegGR}{A \link[GenomicRanges]{GRanges} object representing DEG TSSs.}

\item{CreGR}{A \link[GenomicRanges]{GRanges} object representing the CREs.}

\item{maxDist}{Integer value representing the maximum distance allowed for
associations. Regions further apart than this threshold will not be
associated. (Default: \code{1e6})}
}
\value{
A Hits object containing associations and their distances between
the genomic regions represented by DegGR and CreGR.
}
\description{
This function finds associations and distances between two sets of genomic
regions.
}
\details{
This function identifies associations between genomic regions from two
GenomicRanges objects (DegGR and CreGR) based on their spatial overlap
within a specified maximum distance threshold using
\link[GenomicRanges]{findOverlaps}. It calculates the distances with
\link[GenomicRanges]{distance} between associated regions and stores them
in the metadata of the \link[S4Vectors]{Hits} object.
Large values \code{maxDist} will require more computational resources.
}
\examples{
#Load sample data.
data(DexNR3C1)

# Get hits with association distances.
hits <- getAssocDistHits(DegGR = DexNR3C1$DegGR,
                         CreGR = DexNR3C1$CreGR,
                         maxDist = 1e6)

}
\author{
Brian S. Roberts
}
