% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreCore.R
\name{degCrePRAUC}
\alias{degCrePRAUC}
\title{Calculate PR AUC for DegCre results.}
\usage{
degCrePRAUC(
  degCreResList,
  makePlot = TRUE,
  nShuff = 100,
  alphaVal = degCreResList$alphaVal,
  nThresh = 200
)
}
\arguments{
\item{degCreResList}{A list of DegCre results.}

\item{makePlot}{Logical indicating whether to generate a plot of the
Precision-Recall curve. (Default: \code{TRUE})}

\item{nShuff}{Integer number of shuffles for no-skill curve.
(Default: \code{100})}

\item{alphaVal}{Numeric from 0 to 1 threshold alpha value of DEG
significance. (Default: alpha value from \code{degCreResList})}

\item{nThresh}{Integer number of threshold values for the Precision-Recall
curve. (Default: \code{200})}
}
\value{
Invisibly, a list containing:
\describe{
  \item{actualTprPpvMat}{A matrix of actual True Positive Rate (TPR) and
  apparent Positive Predictive Value (PPV).}
  \item{shuffTprQMat}{A matrix of shuffled TPR quantiles.}
  \item{shuffPpvQMat}{A matrix of shuffled PPV quantiles.}
  \item{AUC}{Numeric of the total Area Under the Curve (AUC) for the
  Precision-Recall curve.}
  \item{deltaAUC}{Numeric of the difference in AUC between the actual curve
  and shuffled curves.}
  \item{normDeltaAUC}{Numeric of the normalized difference in AUC.}
}
}
\description{
This function calculates the Precision-Recall Area Under the Curve (AUC)
from a DegCre results list.
}
\details{
This function calculates the Precision-Recall curve and AUC based on the
provided DegCre results. It also estimates the statistical significance of
the AUC by shuffling the associations and calculating AUC for shuffled data.
Note that the PR AUCs tend to be small (0.05-0.2). Under the calculation
framework, a PR AUC of 1 could only be achieved from DegCre results in
which every association involves a significant DEG and has an association
probability of 1.
This situation will never actually occur but serves as a theoretical
optimum for comparison.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load sample data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

#Plot PR curve.

degCrePRAUC(degCreResList=degCreResListDexNR3C1)

#Get PR results with out plotting.

prAUCList <- degCrePRAUC(degCreResList=degCreResListDexNR3C1,
                        makePlot=FALSE)

}
\author{
Brian S. Roberts
}
