% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreCore.R
\name{adjustRawAssocProb}
\alias{adjustRawAssocProb}
\title{Adjust raw association probability for DEG true positive probability}
\usage{
adjustRawAssocProb(rawAssocProbs, pAdjs, alphaVal = 0.01, method = "qvalue")
}
\arguments{
\item{rawAssocProbs}{Raw association probabilities}

\item{pAdjs}{Adjusted p-values of the DEG.}

\item{alphaVal}{Chosen significance level (only used if \code{method} =
"bonferroni")}

\item{method}{Method for adjusting p-values.
One of "bonferroni" or "qvalue". (Default: \code{qvalue}).}
}
\value{
A numeric vector of adjusted association probilities
}
\description{
For a raw associations probabilities, this function multiplies this
probability by the probability that the DEG is truly differentially
expressed.
}
\details{
Not exported. This function multiplies the raw association probabilities
by the probability that the DEG is truly differential expressed. This "true
DEG" probability is determined depending on the choice of \code{method}. 
For "bonferroni" the probability is 1 if the corresponding pAdj is less than
or equal to \code{alphaVal} and 0 otherwise. For "qvalue" the probability is
1 - localFDR as calculated in \link[qvalue]{lfdr}.
}
\examples{
\dontrun{
adjAssocProbs <- adjustRawAssocProb(myRawAssocProbs,pAdjs=myPadjs,
                                    alphaVal=0.01,method="qvalue")
}
}
\author{
Brian S. Roberts
}
\keyword{internal}
