% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{est_prop_test}
\alias{est_prop_test}
\title{Test Estimated Cell Type Proportions}
\format{
A \code{data.frame} object.
}
\source{
\url{https://github.com/LieberInstitute/DeconvoBuddies/blob/master/inst/extdata/data-raw/est_prop_test.R}
}
\usage{
data("est_prop_test")
}
\description{
A test dataset of estimated proportions for 5 cell types over 100 samples.
}
\details{
11.62 kB

These are the columns of the \code{data.frame} object:
\itemize{
\item cell_A: estimated proportions for cell type A
\item cell_B: estimated proportions for cell type B
\item cell_C: estimated proportions for cell type C
\item cell_D: estimated proportions for cell type D
\item cell_E: estimated proportions for cell type E
}
}
\examples{
## R Note that the `rowSums(est_prop_test)` is equal to 1,
## with a small error tolerance.
data("est_prop_test")
summary(rowSums(est_prop_test) - 1)

## You can check this yourself with:
all(round(rowSums(est_prop_test), 3) == 1)

# To view source
system.file("extdata", "data-raw", "est_prop_test.R", package = "DeconvoBuddies")
}
\keyword{datasets}
