% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_meth_edgeR.R
\name{testDmRegions}
\alias{testDmRegions}
\title{Differential testing}
\usage{
testDmRegions(dge, regions, p.value = 0.05, lfc = 1, plot = TRUE)
}
\arguments{
\item{dge}{A DGEList object as outputted from [makeDGE()].}

\item{regions}{A data.frame of GATC regions.}

\item{p.value}{A number between 0 and 1 providing the required false discovery rate (FDR). Default is 0.05.}

\item{lfc}{A number giving the minimum absolute log2-fold-change for significant results. Default is 1.}

\item{plot}{An option to plot the results using edgeR::plotSmear. Default is TRUE.}
}
\value{
A `data.frame` of differential methylation results. Columns are: Position (chromosome-start), seqnames, start, end, width, strand, number (region number), dm (edgeR result: 0,1,NA), logFC, adjust.p, meth_status (No_signal, Upreg, Not_included).
If plot=TRUE, will also return a [edgeR::plotSmear()] plot of the results.
}
\description{
`testDmRegions` calculates the differential methylation results, identifying which GATC regions have been enriched in the Fusion samples relative to the controls.
Refer to the following pages for further details:
* [edgeR::glmQLFit()]
* [edgeR::glmQLFTest()]
* [edgeR::decideTestsDGE()]
}
\examples{
set.seed(123)
example_regions <- random_regions()
counts.df <- random_counts()
dge <- makeDGE(counts.df)

dm_results <- testDmRegions(dge, regions = example_regions, p.value = 0.05, lfc = 1)
head(dm_results)
}
\references{
Robinson MD, McCarthy DJ, Smyth GK (2010). “edgeR: a Bioconductor package for differential expression analysis of digital gene expression data.” Bioinformatics, 26(1), 139-140. doi:10.1093/bioinformatics/btp616.
McCarthy DJ, Chen Y, Smyth GK (2012). “Differential expression analysis of multifactor RNA-Seq experiments with respect to biological variation.” Nucleic Acids Research, 40(10), 4288-4297. doi:10.1093/nar/gks042.
Chen Y, Lun ATL, Smyth GK (2016). “From reads to genes to pathways: differential expression analysis of RNA-Seq experiments using Rsubread and the edgeR quasi-likelihood pipeline.” F1000Research, 5, 1438. doi:10.12688/f1000research.8987.2.
Chen Y, Chen L, Lun ATL, Baldoni P, Smyth GK (2024). “edgeR 4.0: powerful differential analysis of sequencing data with expanded functionality and improved support for small counts and larger datasets.” bioRxiv. doi:10.1101/2024.01.21.576131.
}
\seealso{
[makeDGE()]
}
