% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qc.R
\name{plotCountsDistribution}
\alias{plotCountsDistribution}
\title{Plot distribution of counts
`plotCountsDistribution` plots the distribution of counts enabling the comparison of different samples.
 Can highlight the different library sizes of the samples.}
\usage{
plotCountsDistribution(counts.df, constant = 1)
}
\arguments{
\item{counts.df}{A counts data.frame as outputted from `countBamInGatc`}

\item{constant}{A numerical offset to avoid log2(0) = -Inf. Default is 1}
}
\value{
A ggplot2 density plot
}
\description{
Plot distribution of counts
`plotCountsDistribution` plots the distribution of counts enabling the comparison of different samples.
 Can highlight the different library sizes of the samples.
}
\examples{
set.seed(123)
counts.df <- random_counts()

plotCountsDistribution(counts.df, 1)
}
