% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatc_track.R
\name{getGatcRegions}
\alias{getGatcRegions}
\title{Extract GATC regions}
\usage{
getGatcRegions(object)
}
\arguments{
\item{object}{A BSgenome package OR the path to a FASTA file.}
}
\value{
A `GRangesList` object of two GRanges; regions - providing the coordinates between adjacent GATC sites, and sites - providing the coordinates of the GATC sites.
}
\description{
`getGatcRegions` identifies and extracts the GATC sites and regions from a BSgenome object or a fasta file.
}
\examples{
if (require("BSgenome.Dmelanogaster.UCSC.dm6")) {
    gatc <- getGatcRegions(BSgenome.Dmelanogaster.UCSC.dm6::BSgenome.Dmelanogaster.UCSC.dm6)

    head(gatc$regions)

    head(gatc$sites)
}
}
