% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_region_de_lfc.R
\name{geom_dm}
\alias{geom_dm}
\title{Plotting results from differential methylation testing}
\usage{
geom_dm(dm_results.df, plot.space = 0.1, plot.height = 0.1)
}
\arguments{
\item{dm_results.df}{A data.frame of differential testing results as outputted from `testDmRegions()`.}

\item{plot.space}{Specify gap to next plot. Recommend leaving to the default: 0.1.}

\item{plot.height}{Specify overall height of plot. Recommend leaving to the default: 0.1.}
}
\value{
A `ggplot_add` object.
}
\description{
`geom_dm.res.lfc` is a ggplot2 layer that visualises the dm_results and logFC across a given region.
}
\details{
* regions are coloured by dm result: 1, 0, NA (grey for NA)
* cannot be plotted by itself, must be added to an existing plot - see examples.
}
\examples{
set.seed(123)
counts.df <- random_counts()
dm_results <- random_edgeR_results()
plotCounts(counts.df,
    seqnames = "chr2L",
    start_region = 1,
    end_region = 40000,
    log2_scale = FALSE
) +
    geom_dm(dm_results)
}
\references{
ggcoverage - Visualise and annotate omics coverage with ggplot2. https://github.com/showteeth/ggcoverage/tree/main
}
\seealso{
[geom_peak()] [plotCounts()] [geom_genes()] [geom_gatc()] [plotWrap()] [ggplot2::ggplot_add()]
}
