% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.BoxPlot.R
\name{DO.BoxPlot}
\alias{DO.BoxPlot}
\title{Box Graph with wilcox test on single cell level}
\usage{
DO.BoxPlot(
  sce_object,
  Feature,
  sample.column = "orig.ident",
  ListTest = NULL,
  group.by = "condition",
  group.by.2 = NULL,
  ctrl.condition = NULL,
  outlier_removal = TRUE,
  plot_sample = TRUE,
  vector_colors = c("#1f77b4", "#ea7e1eff", "royalblue4", "tomato2", "darkgoldenrod",
    "palegreen4", "maroon", "thistle3"),
  wilcox_test = TRUE,
  stat_pos_mod = 1.15,
  step_mod = 0,
  hjust.wilcox = 0.5,
  vjust.wilcox = 0.25,
  size.wilcox = 3.33,
  hjust.wilcox.2 = 0.5,
  vjust.wilcox.2 = 0,
  sign_bar = 0.8,
  orderAxis = NULL
)
}
\arguments{
\item{sce_object}{The SCE object or Seurat}

\item{Feature}{name of the feature/gene}

\item{sample.column}{meta data column containing sample IDs}

\item{ListTest}{List for which conditions wilcox will be performed, if NULL
always CTRL group against everything}

\item{group.by}{group name to look for in meta data}

\item{group.by.2}{second group name to look for in meta data}

\item{ctrl.condition}{select condition to compare to}

\item{outlier_removal}{Outlier calculation}

\item{plot_sample}{Plot individual sample dot in graph}

\item{vector_colors}{get the colours for the plot}

\item{wilcox_test}{If you want to have wilcoxon performed, boolean default
TRUE}

\item{stat_pos_mod}{modificator for where the p-value is plotted increase
for higher}

\item{step_mod}{value for defining the space between one test and the
next one}

\item{hjust.wilcox}{value for adjusting height of the text}

\item{vjust.wilcox}{value for vertical of text}

\item{size.wilcox}{value for size of text of statistical test}

\item{hjust.wilcox.2}{value for adjusting height of the text, with
group.by.2 specified}

\item{vjust.wilcox.2}{value for vertical of text, with group.by.2 specified}

\item{sign_bar}{adjusts the sign_bar with group.by.2 specified}

\item{orderAxis}{vector for xaxis sorting, alphabetically by default}
}
\value{
a ggplot
}
\description{
Creates a box plot using a pseudo-bulk approach and performs a
Wilcoxon test on single-cell level. Allows customization of outlier removal,
statistical labels, and color schemes. Supports comparison of conditions
with optional second grouping. Useful for visualizing gene expression and
statistical differences.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

set.seed(123)
sce_data$orig.ident <-
    sample(rep(c("A", "B", "C"), length.out = ncol(sce_data)))

ListTest <- list()
ListTest[[1]] <- c("healthy", "disease")

DO.BoxPlot(
    sce_object = sce_data,
    Feature = "NKG7",
    sample.column = "orig.ident",
    ListTest = ListTest,
    group.by = "condition",
    ctrl.condition = "healthy",
)

}
\author{
Mariano Ruz Jurado
}
