% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{nodeList}
\alias{nodeList}
\alias{nodeList<-}
\alias{nodeList,DNEA-method}
\alias{nodeList<-,DNEA-method}
\title{Access the node list}
\usage{
nodeList(x)

nodeList(x) <- value

\S4method{nodeList}{DNEA}(x)

\S4method{nodeList}{DNEA}(x) <- value
}
\arguments{
\item{x}{a \code{\link{DNEA}} object.}

\item{value}{a data frame of nodes in the network.}
}
\value{
A data frame corresponding to the node
list determined by DNEA.
}
\description{
The function takes as input a \code{\link{DNEA}} object
and returns the node list created from the
\code{\link{createDNEAobject}} function.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

nodeList(dnw)
}
\seealso{
\code{\link{createDNEAobject}},\code{\link{clusterNet}},
\code{\link{getNetworkFiles}}
}
\author{
Christopher Patsalis
}
