% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R, R/all-methods.R
\docType{class}
\name{DNEA-class}
\alias{DNEA-class}
\alias{show,DNEA-method}
\title{DNEA object}
\usage{
\S4method{show}{DNEA}(object)
}
\arguments{
\item{object}{A \code{\link{DNEA}} object.}
}
\value{
A DNEA object

A summary of the information stored in a
\code{\link{DNEA}} object.
}
\description{
An s4 class to represent the DNEA workflow
}
\section{Functions}{
\itemize{
\item \code{show(DNEA)}: This function will display a summary of the information
stored within a \code{\link{DNEA}} object.

}}
\section{Slots}{

\describe{
\item{\code{project_name}}{A character string name for the experiment.}

\item{\code{assays}}{A list of matrices, "input_data" being the original
non-normalized, non-transformed data, "log_input_data" is the
input data log transformed, and "log-scaled_input" is the input
data log-transformed and auto-scaled. The row names between the
input assays must be identical (the expression data can be
accessed via the \code{\link{expressionData}} function).
Any other assay input into the DNEA object can be accessed
by supplying its name to the assay parameter.}

\item{\code{metadata}}{A list of information about the data, including a
data frame for sample metadata (the row names must match the
sample order of the stored expression data), a data frame for
feature metadata  (the row names must match the feature order of
the stored expression data), a two-level factor corresponding to
the two groups in the data, and a character vector the same length as the
number of samples corresponding to the group membership for each sample
(the user may add additional metadata via the
\code{\link{includeMetadata}} function).}

\item{\code{dataset_summary}}{A \code{DNEAinputSummary} object (can view data
via \code{\link{datasetSummary}} and \code{\link{diagnostics}})}

\item{\code{node_list}}{A data frame containing all of the features in the
data set as rows as well as the differential expression analysis
results (can view the node list via \code{\link{nodeList}}).}

\item{\code{edge_list}}{A data frame containing the network edges identified
via \code{\link{getNetworks}} (can view the edge list via
\code{\link{edgeList}}).}

\item{\code{hyperparameter}}{A list of results obtained from
\code{\link{BICtune}} containing a numeric vector of the
lambda values tested during optimization, the resulting
Bayesian-information criterion and likelihood scores for each
lambda value, and the optimized lambda for analysis (the optimized
lambda can be accessed or changed via the
\code{\link{optimizedLambda}} function).}

\item{\code{adjacency_matrix}}{A list of adjacency matrices, one for each
experimental condition, jointly estimated via
\code{\link{getNetworks}}.}

\item{\code{stable_networks}}{A list of the selection results and
selection probabilities, one for each experimental condition,
for every possible feature-feature edge.}

\item{\code{consensus_clustering}}{A \code{consensusClusteringResults}
object containing the results from consensus clustering
obtained via the \code{\link{clusterNet}} function.}

\item{\code{netGSA}}{a data frame containing the results from
enrichment analysis performed via \code{\link{runNetGSA}} and
the \code{\link[netgsa:NetGSA]{NetGSA}} algorithm. Each row is the
results for a given sub network tested for enrichment.}
}}

\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

dnw
}
\seealso{
\code{\link{expressionData}},\code{\link{includeMetadata}},
\code{\link{nodeList}},\code{\link{edgeList}},
\code{\link{datasetSummary}},\code{\link{diagnostics}},
\code{\link{BICtune}},\code{\link{getNetworks}},
\code{\link{stabilitySelection}},\code{\link{clusterNet}},
\code{\link{runNetGSA}},\code{\link{selectionProbabilities}},
\code{\link{selectionResults}},\code{\link{createDNEAobject}},

\code{\link{createDNEAobject}},
\code{\link{aggregateFeatures}}
}
\author{
Christopher Patsalis
}
