% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methVars-method.R
\name{methVars-method}
\alias{methVars-method}
\alias{methVars,BSDMCs-method}
\alias{methVars}
\alias{methVars<-,BSDMCs,matrix-method}
\alias{methVars<-}
\title{methVars method}
\usage{
methVars(object)

methVars(object) <- value

\S4method{methVars}{BSDMCs}(object)

\S4method{methVars}{BSDMCs,matrix}(object) <- value
}
\arguments{
\item{object}{A \code{\link{BSData-class}} or \code{\link{BSDMCs-class}}
object}

\item{value}{An integer matrix}
}
\value{
A matrix

A \code{\link{BSDMCs-class}} object
}
\description{
Returns \code{methVars} stored in \code{\link{BSDMCs-class}}

Assigns \code{methVars} to \code{\link{BSDMCs-class}}
}
\examples{
set.seed(1980)
nr <- 150; nc <- 8
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n=nr*nc,c(metht),prob = runif(nr*nc)),nr,nc)
meths <- matrix(as.integer(runif(nr * nc, 0, 10)), nr)
methl <- methc/metht
methv <- matrix((runif(nr * nc, 0.1, 0.5)), nr)
r1 <- GRanges(rep('chr1', nr), IRanges(1:nr, width=1), strand='*')
names(r1) <- 1:nr
cd1 <- DataFrame(Group=rep(c('G1','G2'),each=nc/2),row.names=LETTERS[1:nc])
OBJ2 <- cBSDMCs(rowRanges=r1,methReads=methc,totalReads=metht,
methLevels=methl,methStates=meths,methVars=methv,colData=cd1)
methVars(OBJ2)
methVars(OBJ2)<- meths
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
