% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methReads-method.R
\name{methReads-method}
\alias{methReads-method}
\alias{methReads,BSDMC-method}
\alias{methReads}
\alias{methReads<-,BSDMC,matrix-method}
\alias{methReads<-}
\title{methReads method}
\usage{
methReads(object)

methReads(object) <- value

\S4method{methReads}{BSDMC}(object)

\S4method{methReads}{BSDMC,matrix}(object) <- value
}
\arguments{
\item{object}{A \code{\link{BSDMC-class}}
object}

\item{value}{An integer matrix}
}
\value{
A matrix

A \code{\link{BSDMC-class}} object
}
\description{
Returns \code{methReads} stored in \code{\link{BSDMC-class}}

Assigns \code{methReads} to \code{\link{BSDMC-class}}
}
\examples{
nr <- 150
nc <- 8
metht <- matrix(as.integer(runif(nr * nc, 0, 100)), nr)
methc <- matrix(rbinom(n = nr * nc, c(metht), prob = runif(nr * nc)), nr, nc)
methl <- methc / metht
r1 <- GRanges(rep("chr1", nr), IRanges(1:nr, width = 1), strand = "*")
names(r1) <- 1:nr
cd1 <- DataFrame(
  Group = rep(c("G1", "G2"), each = nc / 2),
  row.names = LETTERS[1:nc]
)
OBJ1 <- cBSDMC(
  rowRanges = r1, methReads = methc, totalReads = metht,
  methLevels = methl, colData = cd1
)
methReads(OBJ1)
methReads(OBJ1) <- methc
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
