% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svg_test.R
\name{svg_test}
\alias{svg_test}
\title{svg_test}
\usage{
svg_test(
  spe,
  cluster_col,
  sample_col = NULL,
  replicates = FALSE,
  min_counts = 20,
  min_non_zero_spots = 10,
  filter_gene = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{spe}{SpatialExperiment or SingleCellExperiment.}

\item{cluster_col}{Column name of spatial clusters in \code{colData(spe)}.}

\item{sample_col}{Column name of sample ids in \code{colData(spe)}.}

\item{replicates}{A logical, indicating whether biological replicates are provided (TRUE) or not (FALSE).
If biological replicates are provided, \code{\link{svg_test}} performs a joint test across all replicates, 
searching for SVGs with consistent spatial patterns across samples.}

\item{min_counts}{Minimum number of counts per sample (across all spots) for a gene to be analyzed.}

\item{min_non_zero_spots}{Minimum number of non-zero spots per sample, for a gene to be analyzed.}

\item{filter_gene}{A logical. If TRUE, 
\code{\link{svg_test}} filters genes:
genes have to be expressed in at least 'min_non_zero_spots' spots,    
and a gene requires at least 'min counts' counts per sample (across all locations).}

\item{verbose}{A logical.
If TRUE, \code{\link{svg_test}} returns two more results: 
'DGEGLM' and 'DGELRT' objects contain full statistics from 'edgeR::glmFit' and 'edgeR::glmLRT'.}
}
\value{
A list of results:

- "gene_results": a dataframe contains main edgeR test results;

- "estimated_y": a DGEList object contains the estimated common dispersion, 
which can later be used to speed-up calculation when testing individual clusters.

- "glmFit" (only if \code{verbose = TRUE}): a DGEGLM object contains full statistics from "edgeR::glmFit".

- "glmLRT" (only if \code{verbose = TRUE}): a DGELRT object contains full statistics from "edgeR::glmLRT".
}
\description{
'svg_test' identifies spatially variable genes (SVGs) from spatially-resolved transcriptomics data,
provided spatial clusters are available.
}
\details{
If 'sample_col' is not specified and 'replicates == FALSE',
\code{\link{svg_test}} assumed that data comes from an individual sample, 
and performs SV testing on it.

If 'sample_col' is provided and 'replicates == FALSE',
\code{\link{svg_test}} tests each sample individually and returns a list of results for each sample.

If 'sample_col' is provided and 'replicates == TRUE',
\code{\link{svg_test}} performs a joint multi-sample test.
}
\examples{
# load the input data:
data("LIBD_subset", package = "DESpace")
LIBD_subset

# Fit the model via \code{\link{svg_test}} function.
set.seed(123)
results_svg_test <- svg_test(spe = LIBD_subset,
                             cluster_col = "layer_guess_reordered",
                             verbose = FALSE)

# svg_test returns of a list of 2 objects:
# "gene_results": a dataframe contains main edgeR test results;
# "estimated_y": a DGEList object contains the estimated common dispersion, 
#  which can later be used to speed-up calculation when testing individual clusters.

# We visualize differential results:
head(results_svg_test$gene_results, 3)

}
\seealso{
\code{\link{top_results}}, \code{\link{individual_svg}}, \code{\link{FeaturePlot}}, \code{\link{dsp_test}}, \code{\link{individual_dsp}}
}
