% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_frequencies.R
\name{plot_coverage}
\alias{plot_coverage}
\title{Plot protein coverage}
\usage{
plot_coverage(se, plot = TRUE)
}
\arguments{
\item{se}{SummarizedExperiment,
Data object for which to plot observation frequency.}

\item{plot}{Logical(1),
If \code{TRUE} (default) the barplot is produced.
Otherwise (if \code{FALSE}), the data which the
barplot is based on are returned.}
}
\value{
Barplot of protein coverage in samples
(generated by \code{\link[ggplot2]{ggplot}})
}
\description{
\code{plot_coverage} generates a barplot
of the protein coverage in all samples.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter and plot coverage
filt <- filter_missval(se, thr = 0)
plot_coverage(filt)
}
