#' Count matrices of intestinal epithelial scRNA-seq data from three conditions
#'
#' A data containing the count matrices, the similarity matrix and other 
#' variables used to generate the similarity matrix from intestinal epithelial 
#' single cell RNA sequencing data with three condition. Count matrices are 
#' calculated based on the number of cells in each cell type. The similarity 
#' matrix is calculated by support vector machine classifiers using 5-fold 
#' cross validation. Top 30 PCs are used as predictors.
#'
#' @format A list with 7 items:
#' \describe{
#'   \item{count_ctrl}{the count matrix for the control group}
#'   \item{count_Hpoly3}{the count matrix for three days after H.polygyrus infection}
#'   \item{count_Hpoly10}{the count matrix for ten days after H.polygyrus infection}
#'   \item{count_Salma}{the count matrix for two days after Salmonella infection}
#'   \item{svm_mat}{the similarity matrix}
#'   \item{source}{the source of this dataset}
#' }
#' @source \url{https://www.nature.com/articles/nature24489}
#' @examples 
#' library(DCATS)
#' data(Haber2017)
"Haber2017"

#' Count matrices of 8 pooled lupus patient samples within two conditions
#'
#' A data containing the count matrices, the similarity matrix and other 
#' variables used to generate the similarity matrix 
#' from single cell RNA sequencing data of 8 pooled lupus patient samples within 
#' two conditions. Count matrices are 
#' calculated based on the number of cells in each cell type. The similarity 
#' matrix is calculated by support vector machine classifiers using 5-fold 
#' cross validation. Top 30 PCs are used as predictors. The svmDF contains 30 
#' PCs generated by standard Seurat pipeline and the condition, cell type 
#' information collected from the original paper.
#'
#' @format A list with 5 items:
#' \describe{
#'   \item{count_ctrl}{the count matrix for three days after H.polygyrus infection}
#'   \item{count_stim}{the count matrix for ten days after H.polygyrus infection}
#'   \item{svm_mat}{the simularity matrix}
#'   \item{svmDF}{the data frame used to calculate the similarity matrix.}
#'   \item{source}{the source of this dataset}
#' }
#' @source \url{https://www.nature.com/articles/nbt.4042}
"Kang2017"

#' Count matrix and metadata of a large COVID-19 scRNA-seq data cohort.
#'
#' A data containing the count matrix, metadata from a large COVID-19 cohort.
#' Count matrices are 
#' calculated based on the number of cells in each cell type. The information 
#' in the design matrix is collected in the original paper.
#'
#' @format A list with 7 items:
#' \describe{
#'   \item{countM}{the count matrix for all samples comming from different condition}
#'   \item{designM}{the corresponding metadata related to each sample}
#'   \item{source}{the source of this dataset}
#' }
#' @source \url{https://www.nature.com/articles/nature24489}
"Ren2021"

#' Simulated dataset with two conditions
#'
#' A data containing the count matrices, the similarity matrix and other 
#' variables used to generate the similarity matrix 
#' from a simulated single cell RNA sequencing data with two conditions. 
#' Dirichlet distribution was used to generate a proportion vector for cell 
#' types based on the defined true proportions. Multinomial distribution was 
#' used to generate simulated cell numbers. Cells were selected from cell pools
#' based on cell numbers and gene expression matrices were processed by Seurat.
#' The count matrix were calculated by the clustering results, and the 
#' similarity matrix was calculated using knn graph. The labels are the groud
#' true annotation of each cell.
#'
#' @format A list with 5 items:
#' \describe{
#'   \item{numb_cond1}{the count matrix of condition 1}
#'   \item{numb_cond2}{the count matrix of condition 2}
#'   \item{knn_mat}{the similariy matrix}
#'   \item{knnGraphs}{the knn graphs information used to calculate the 
#'   similarity matrix.}
#'   \item{labels}{the clusters' label for each simulated single cell}
#' }
"simulation"
