% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_heatmaps.R
\name{heatmapD}
\alias{heatmapD}
\title{This function is a wrapper to \code{heatmap.2} that displays
quantitative data in the \code{Biobase::exprs()} table of an object of
class \code{MSnSet}}
\usage{
heatmapD(
  qData,
  conds,
  distance = "euclidean",
  cluster = "complete",
  dendro = FALSE
)
}
\arguments{
\item{qData}{A dataframe that contains quantitative data.}

\item{conds}{A vector containing the conditions}

\item{distance}{The distance used by the clustering algorithm to compute
the dendrogram. See \code{help(heatmap.2)}}

\item{cluster}{the clustering algorithm used to build the dendrogram.
See \code{help(heatmap.2)}}

\item{dendro}{A boolean to indicate fi the dendrogram has to be displayed}
}
\value{
A heatmap
}
\description{
This function is a wrapper to \code{heatmap.2} that displays
quantitative data in the \code{Biobase::exprs()} table of an object of
class \code{MSnSet}
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10), ]
level <- 'peptide'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeLine(metacell.mask)
qData <- Biobase::exprs(obj)
conds <- Biobase::pData(obj)[["Condition"]]
heatmapD(qData, conds)


}
\author{
Florence Combes, Samuel Wieczorek, Enor Fremy
}
