% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffAnalysis.R
\name{diffAnaComputeAdjustedPValues}
\alias{diffAnaComputeAdjustedPValues}
\title{Computes the adjusted p-values}
\usage{
diffAnaComputeAdjustedPValues(pval, pi0Method = 1)
}
\arguments{
\item{pval}{The result (p-values) of the differential analysis processed
by \code{\link{limmaCompleteTest}}}

\item{pi0Method}{The parameter pi0.method of the method adjust.p in the 
package \code{cp4p}}
}
\value{
The computed adjusted p-values
}
\description{
This function is a wrapper to the function adjust.p from the `cp4p` package.
 It returns the FDR corresponding to the p-values of the differential 
analysis. The FDR is computed with the function \code{p.adjust}\{stats\}.
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(1000)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
qData <- Biobase::exprs(obj$new)
sTab <- Biobase::pData(obj$new)
limma <- limmaCompleteTest(qData, sTab)
df <- data.frame(id = rownames(limma$logFC), logFC = limma$logFC[, 1], pval = limma$P_Value[, 1])

diffAnaComputeAdjustedPValues(pval = limma$P_Value[, 1])

}
\author{
Samuel Wieczorek
}
