% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_asm.R
\name{calc_score}
\alias{calc_score}
\title{Calculate score}
\usage{
calc_score(df, beta = 0.5, a = 0.2)
}
\arguments{
\item{df}{data frame of a sample containing all information per tuple
(MM,UU,UM and MU counts, as well as the log odds ratio per tuple) needed
for the ASM score.}

\item{beta}{parameter for the \code{calc_weight} function. It's the alpha and
beta values for the Beta function.}

\item{a}{parameter for the calc_weight function. The weight will be the
probability that the MM/(MM+UU) ratio lies between 0.5-a and 0.5+a.}
}
\value{
The same object with an additional column for the ASM score.
}
\description{
This function calculates the ASM score for every tuple in a given sample. The
ASM score is a multiplication of the log odds ratio by a weight that reflects
the extent of allele-specific methylation. This weight is obtained with the
\code{\link{calc_weight}} function.
}
\details{
This function returns an allele-specific methylation (ASM) score for
  every given tuple in a sample. The ASM score is a product of the log odds
  ratio and a weight reflecting a measure of allele-specificity using the MM
  and UU counts.
}
