% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev.R
\name{update_database}
\alias{update_database}
\title{Update the metadata database in nectar using a newly created data frame}
\usage{
update_database(metadata, version, ...)
}
\arguments{
\item{metadata}{The data frame to upload}

\item{version}{The version for the new metadata as a character scalar, e.g.
"0.2.3"}

\item{...}{
  Arguments passed on to \code{\link[=upload_swift]{upload_swift}}
  \describe{
    \item{\code{source}}{A character scalar indicating the local path to the file to
upload}
    \item{\code{container}}{A character scalar indicating the name of the container to
upload to}
    \item{\code{name}}{An optional character scalar indicating the name the file should
have after being uploaded. Defaults to being the basename of the source
file.}
    \item{\code{credential_id}}{The OpenStack application credential secret as a
character scalar}
  }}
}
\value{
\code{NULL}, invisibly
}
\description{
Update the metadata database in nectar using a newly created data frame
}
\examples{
\dontrun{
 metadata = CuratedAtlasQueryR::get_metadata() |>
     head(10) |>
     dplyr::collect()
 update_database(
     metadata, 
     "0.2.3", 
     credential_id = "ABCDEFGHIJK", 
     credential_secret = "ABCD1234EFGH-5678IJK"
 )
 # Prints "metadata.0.2.3.parquet" if successful
}
}
\keyword{internal}
