% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongTable-utils.R
\name{[,LongTable,ANY,ANY,ANY-method}
\alias{[,LongTable,ANY,ANY,ANY-method}
\title{[ LongTable Method}
\usage{
\S4method{[}{LongTable,ANY,ANY,ANY}(x, i, j, assays = assayNames(x), ..., drop = FALSE)
}
\arguments{
\item{x}{\code{LongTable} The object to subset.}

\item{i}{\code{character}, \code{numeric}, \code{logical} or \code{call}
Character: pass in a character vector of drug names, which will subset the
object on all row id columns matching the vector. This parameter also
supports valid R regex query strings which will match on the colnames
of \code{x}. For convenience, * is converted to .* automatically. Colon
can be to denote a specific part of the colnames string to query.
Numeric or Logical: these select based on the rowKey from the \code{rowData}
method for the \code{LongTable}.
Call: Accepts valid query statements to the \code{data.table} i parameter as
a call object. We have provided the function .() to conveniently
convert raw R statements into a call for use in this function.}

\item{j}{\code{character}, \code{numeric}, \code{logical} or \code{call}
Character: pass in a character vector of drug names, which will subset the
object on all drug id columns matching the vector. This parameter also
supports regex queries. Colon can be to denote a specific part of the
colnames string to query.
Numeric or Logical: these select based on the rowID from the \code{rowData}
method for the \code{LongTable}.
Call: Accepts valid query statements to the \code{data.table} i parameter as
a call object. We have provided the function .() to conveniently
convert raw R statements into a call for use in this function.}

\item{assays}{\code{character} Names of assays which should be kept in the
\code{LongTable} after subsetting.}

\item{...}{Included to ensure drop can only be set by name.}

\item{drop}{\code{logical} Included for compatibility with the '[' primitive,
it defaults to FALSE and changing it does nothing.}
}
\value{
A \code{LongTable} containing only the data specified in the function
parameters.
}
\description{
Single bracket subsetting for a LongTable object. See subset for more details.
}
\details{
This function is endomorphic, it always returns a LongTable object.
}
\examples{
# Character
merckLongTable['ABT-888', 'CAOV3']
# Numeric
merckLongTable[1, c(1, 2)]
# Logical
merckLongTable[, colData(merckLongTable)$sampleid == 'A2058']
# Call
merckLongTable[
     .(drug1id == 'Dasatinib' & drug2id != '5-FU'),
     .(sampleid == 'A2058'),
 ]

}
