% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\docType{methods}
\name{buildComboProfiles,LongTable-method}
\alias{buildComboProfiles,LongTable-method}
\title{Build an assay table with selected assay profiles for drug combinations}
\usage{
\S4method{buildComboProfiles}{LongTable}(object, profiles)
}
\arguments{
\item{object}{\code{LongTable} or inheriting class containing curated drug combination data.}

\item{profiles}{\code{character} a vector of profile names, i.e., column names of assays.}
}
\value{
A \code{data.table} containing fields
\code{treatment1id}, \code{treatment1dose}, \code{treatment2id}, \code{treatment2dose}, \code{sampleid},
which are used as keys to keep track of profiles,
along with columns of selected profiles from their assays.
Each \verb{*_1} is the monothearpy profile of treatment 1 in the combination,
and the same rule applies to treatment 2.
}
\description{
Build an assay table with selected assay profiles for drug combinations
}
\examples{
\dontrun{
combo_profile_1 <- buildComboProfiles(tre, c("auc", "SCORE"))
combo_profile_2 <- buildComboProfiles(tre, c("HS", "EC50", "E_inf", "ZIP"))
}

}
