% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immutable-class.R
\name{assignment-immutable}
\alias{assignment-immutable}
\alias{subset<-.immutable}
\alias{subset<-.immutable,}
\alias{[<-.immutable,}
\alias{[[<-.immutable,}
\alias{$<-.immubtale,}
\alias{colnames<-.immutable,}
\alias{rownames<-.immutable,}
\alias{dimnames<-.immutable,}
\alias{names<-.immutable}
\alias{[<-}
\alias{[<-.immutable}
\alias{[[<-}
\alias{[[<-.immutable}
\alias{$<-}
\alias{$<-.immutable}
\alias{names<-}
\alias{dimnames<-}
\alias{dimnames<-.immutable}
\alias{colnames<-}
\alias{colnames<-.immutable}
\alias{rownames<-}
\alias{rownames<-.immutable}
\title{Intercept assignment operations for "immutable" S3 objects.}
\usage{
\\method{subset}{immutable}(object, ...) <- value

\method{[}{immutable}(object, ...) <- value

\method{[[}{immutable}(object, ...) <- value

\method{$}{immutable}(object, ...) <- value

\method{names}{immutable}(x) <- value

\method{dimnames}{immutable}(x) <- value

\\method{colnames}{immutable}(x) <- value

\\method{rownames}{immutable}(x) <- value
}
\arguments{
\item{object, x}{An R object inherting from the "immutable" S3-class.}

\item{...}{Catch subset arguments for various dimensions.}

\item{value}{Not used.}
}
\value{
None, throws an error.
}
\description{
Prevents modification of objects labelled with the "immutable" S3-class by
intercepting assignment during S3-method dispatch and returning an error.
}
\examples{
immutable_df <- immutable(data.frame(a=1:5, b=letters[1:5]))
# return immutable data.frame
immutable_df[1:4, ]
# return immutable vector
immutable_df$a

}
