% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizMethods.R
\name{PlotClusterTree}
\alias{PlotClusterTree}
\alias{PlotClusterTree.SingleCellExperiment}
\alias{PlotClusterTree,SingleCellExperiment-method}
\title{Plot cluster tree}
\usage{
PlotClusterTree.SingleCellExperiment(
  object,
  icp.run,
  color.by,
  use.color,
  seed.color,
  legend.title,
  return.data
)

\S4method{PlotClusterTree}{SingleCellExperiment}(
  object,
  icp.run,
  color.by = NULL,
  use.color = NULL,
  seed.color = 123,
  legend.title = color.by,
  return.data = FALSE
)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class.}

\item{icp.run}{ICP run(s) to retrieve from \code{metadata(object)$coralysis$joint.probability}.
By default \code{NULL}, i.e., all are retrieved. Specify a numeric vector to
retrieve a specific set of tables.}

\item{color.by}{Categorical variable available in \code{colData(object)} to
plot. If \code{NULL} the cluster probability is represented instead.
By default \code{NULL}.}

\item{use.color}{Character specifying the colors. By default \code{NULL}, i.e.,
colors are randomly chosen based on the seed given at \code{seed.color}.}

\item{seed.color}{Seed to randomly select colors. By default \code{123}.}

\item{legend.title}{Legend title. By default the same as given at \code{color.by}.
Ignored if \code{color.by} is \code{NULL}.}

\item{return.data}{Return data frame used to plot. Logical. By default \code{FALSE},
i.e., only the plot is returned.}
}
\value{
A plot of class \code{ggplot} or a list with a plot of class \code{ggplot} and a data frame.
}
\description{
Plot cluster tree by or cluster probability or categorical variable.
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Prepare SCE object for analysis
sce <- PrepareData(sce)

# Multi-level integration (just for highlighting purposes; use default parameters)
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "Batch", k = 4,
    L = 25, C = 1, d = 0.5, train.with.bnn = FALSE,
    use.cluster.seed = FALSE, build.train.set = FALSE,
    ari.cutoff = 0.1, threads = 2, RNGseed = 1024
)

# Plot probability
PlotClusterTree(object = sce, icp.run = 2)

# Plot batch label distribution
PlotClusterTree(object = sce, icp.run = 2, color.by = "Batch")

# Plot species label distribution
PlotClusterTree(object = sce, icp.run = 2, color.by = "Species")

}
\keyword{Dimensional}
\keyword{reduction}
\keyword{visualization}
