% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{GetCellClusterProbability}
\alias{GetCellClusterProbability}
\alias{GetCellClusterProbability.SingleCellExperiment}
\alias{GetCellClusterProbability,SingleCellExperiment-method}
\title{Get ICP cell cluster probability}
\usage{
GetCellClusterProbability.SingleCellExperiment(
  object,
  icp.run,
  icp.round,
  concatenate
)

\S4method{GetCellClusterProbability}{SingleCellExperiment}(
  object,
  icp.run = NULL,
  icp.round = NULL,
  concatenate = TRUE
)
}
\arguments{
\item{object}{An object of \code{SingleCellExperiment} class with ICP cell
cluster probability tables saved in \code{metadata(object)$coralysis$joint.probability}.
After running \code{RunParallelDivisiveICP}.}

\item{icp.run}{ICP run(s) to retrieve from \code{metadata(object)$coralysis$joint.probability}.
By default \code{NULL}, i.e., all are retrieved. Specify a numeric vector to
retrieve a specific set of tables.}

\item{icp.round}{ICP round(s) to retrieve from \code{metadata(object)$coralysis$joint.probability}.
By default \code{NULL}, i.e., all are retrieved.}

\item{concatenate}{Concatenate list of ICP cell cluster probability tables retrieved.
By default \code{TRUE}, i.e., the list of ICP cell cluster probability tables is
concatenated.}
}
\value{
A list with ICP cell cluster probability tables or a matrix with
concatenated tables.
}
\description{
Get ICP cell cluster probability table(s)
}
\examples{
# Import package
suppressPackageStartupMessages(library("SingleCellExperiment"))

# Create toy SCE data
batches <- c("b1", "b2")
set.seed(239)
batch <- sample(x = batches, size = nrow(iris), replace = TRUE)
sce <- SingleCellExperiment(
    assays = list(logcounts = t(iris[, 1:4])),
    colData = DataFrame(
        "Species" = iris$Species,
        "Batch" = batch
    )
)
colnames(sce) <- paste0("samp", 1:ncol(sce))

# Prepare SCE object for analysis
sce <- PrepareData(sce)

# Multi-level integration (just for highlighting purposes; use default parameters)
set.seed(123)
sce <- RunParallelDivisiveICP(
    object = sce, batch.label = "Batch",
    k = 2, L = 25, C = 1, train.k.nn = 10,
    train.k.nn.prop = NULL, use.cluster.seed = FALSE,
    build.train.set = FALSE, ari.cutoff = 0.1,
    threads = 2, RNGseed = 1024
)

# Get cluster probability for all ICP runs
probs <- GetCellClusterProbability(object = sce, icp.round = 1, concatenate = TRUE)
probs[1:10, 1:5]

}
\keyword{Cell}
\keyword{cluster}
\keyword{probability}
