% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCopyNumberCalls.R
\name{plotCopyNumberCalls}
\alias{plotCopyNumberCalls}
\title{plotCopyNumberCalls}
\usage{
plotCopyNumberCalls(karyoplot, cn.calls, cn.values=NULL, cn.column="cn", cn.colors=NULL, loh.values=NULL, loh.column="loh", loh.color="#1E90FF", loh.height=0.3, labels=NULL, label.cex=1, label2.cex=NULL,track.margin=0.01, r0=0, r1=1, ...)
}
\arguments{
\item{karyoplot}{A karyoplote object}

\item{cn.calls}{(a GRanges, a list of GRanges or a GRangesList) An object with the positions of the CN calls and a column with the CN values. Other columns are ignored. If it's a list of GRanges with different samples, all samples will be plotted, splitting the total plot space between them.}

\item{cn.values}{(integer vector) The CN values. If NULL, they will be extracted from the cn.calls (defaults to NULL)}

\item{cn.column}{(integer or character vector) The name or number of the column with CN information.(defaults to "cn")}

\item{cn.colors}{(colors) The colors assigned to gains and losses (defaults to NULL)}

\item{loh.values}{(logical vector) A logical vector that indicates whether there is or not LOH or a vector that can be coerced as logical. (defaults to NULL)}

\item{loh.column}{(number or character) The name or number of the column with LRR information. (defaults to "loh")}

\item{loh.color}{(a color) The color assigned to LOH values. (defaults to "#1E90FF")}

\item{loh.height}{(numeric) The proportion of r0 and r1 of the vertical space over each chromosome dedicated to loh. It is dedicated the 30\% of the vertical space by default.(defaults to 0.3)}

\item{labels}{(character) The text of the label to identify the data. If NA, no label will be plotted. If NULL, if snps is a single sample GRanges it will default to "CN", if it's a list of samples it will default to the names in the list or consecutive numbers if names(snps) is NULL. (defaults to NULL)}

\item{label.cex}{(numeric) The size of tthe label (defaults to 1)}

\item{label2.cex}{(numeric) The size of the label 2. If NULL label2.cex will be lable.cex. (defaults to NULL)}

\item{track.margin}{(numeric) If cn.calls is a list object, this is the margin between the samples CN. (deafults to 0.01)}

\item{r0}{(numeric) (karyoploteR parameter) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)(defaults to 0)}

\item{r1}{(numeric) (karyoploteR parameter) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)(defaults to 1)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to karyoploteR functions.}
}
\value{
Invisibly returns the karyoplot object representing the plot. With it
it is possible to add other elements to the plot using standrad karyoploteR
functions
}
\description{
Plot the segments representing the copy number calls by any algorithm
}
\details{
Plots the copy number calls as colored rectangles in the karyoplot. Each
copy number status has its own color (including 2n, normal genome) and
these colors may be specified by cn.colors. If LOH data is available
it will be plotted below the copy number data, with a colored rectangle
for every LOH region. The input is simply a GRanges object with an
additional column containing the copy number status (as integers) and
optionally another column containing the LOH status of each region.

If there's only one label, it will be used to label both Copy Number and
LOH. If there are at least two labels, the first one is used to label the
Copy Number and the second one to labvel the LOH.

If the function is called with a list of GRanges it plots every GRanges
independently as different tracks one below the other. Track positioning is
based on `autotrack` and the margin between track is controlled by
`track.margin`.
}
\examples{

s1.calls.file <- system.file("extdata", "S1.segments.txt", package = "CopyNumberPlots", mustWork = TRUE)
s1.calls <- loadCopyNumberCalls(s1.calls.file)

s2.calls.file <- system.file("extdata", "S2.segments.txt", package = "CopyNumberPlots", mustWork = TRUE)
s2.calls <- loadCopyNumberCalls(s2.calls.file)

kp <- plotKaryotype(chromosomes="chr1")
#plotCopyNumberCalls(kp, s1.calls)

kp <- plotKaryotype(chromosomes="chr1")
#plotCopyNumberCalls(kp, s1.calls, cn.colors="red_blue")

#List of GRanges
cn.calls <- list(s1=s1.calls, s2 =s2.calls)

kp <-plotKaryotype(chromosomes="chr1")
#plotCopyNumberCalls(kp, cn.calls, cn.colors="red_blue")

}
