% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Ztree2Hclust}
\alias{Ztree2Hclust}
\title{Ztree2Hclust}
\usage{
Ztree2Hclust(Ztree)
}
\arguments{
\item{Ztree}{(matrix) A matrix with 4 rows and num.elements - 1 columns.
The first and second row represent the elements or clusters merged at each
step and the third row the distance between the merged elements. This
is the format used by scipy hierarchical clustering.}
}
\value{
A valid hclust object (standard R hierarchical clustering results)
}
\description{
Transform a Z matrix representing the hierarchical clustering of elements
into a valid hclust R object. The Z representation is used by scipy 
hierarchical clustering and in 10X single-cell CNV HDF5 files.

More info on the Ztree matrix: \url{https://joernhees.de/blog/2015/08/26/scipy-hierarchical-clustering-and-dendrogram-tutorial/}
}
\examples{

ztree <- matrix(c(0,4,0.1,2,
                  1,3,0.2,2,
                  5,2,0.3,2,
                  6,7,0.4,2),
                  nrow=4)
                
 hc.tree <- Ztree2Hclust(ztree)
 plot(hc.tree)

}
