% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoSIA-class.R
\docType{class}
\name{CoSIAn-class}
\alias{CoSIAn-class}
\title{CoSIAn Class S4 Object}
\value{
CoSIAn object
}
\description{
This Class is used to specify the information needed to conduct
analysis using CoSIA's other methods. An object of this class will pass as an
argument to other methods in CoSIA
}
\section{Slots}{

\describe{
\item{\code{gene_set}}{character. A singular gene or a list of genes.}

\item{\code{i_species}}{character. The species corresponding to gene_set.}

\item{\code{input_id}}{character. The type of id corresponding to gene_set.}

\item{\code{o_species}}{character. The singular or list of species that the gene set
is being converted to.}

\item{\code{output_ids}}{character. The singular or list of id types that the gene
set is being converted to.}

\item{\code{mapping_tool}}{character. The mapping tool, BiomaRt or annotationDBI,
being used to map the conversion between IDs.}

\item{\code{ortholog_database}}{character. The ortholog database, HomoloGene or
NCBIOrtho, being used to map the conversion between species.}

\item{\code{converted_id}}{data frame. Output of getConversion.}

\item{\code{map_tissues}}{character. A list of tissues being investigated.}

\item{\code{map_species}}{character. A list of species being investigated.}

\item{\code{gex}}{data frame. Output of gene expression data.}

\item{\code{metric_type}}{character. A list of possible metric the user wants to
calculate.}

\item{\code{metric}}{data frame. Output of coefficient of variation of gene
expression data.}
}}

